---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-kubectl api-resources

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` - api-resourcesコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServerPreferredResourcesで推奨リソース一覧を取得する | E-01 行180 | ○ |
| C-02 | --api-groupフラグでAPIグループフィルタリングが可能 | E-01 行109, 208-210 | ○ |
| C-03 | --namespacedフラグでNamespace scopeフィルタリングが可能 | E-01 行110, 212-213 | ○ |
| C-04 | --verbsフラグで動詞フィルタリングが可能 | E-01 行111, 216-217 | ○ |
| C-05 | --categoriesフラグでカテゴリフィルタリングが可能 | E-01 行114, 220-221 | ○ |
| C-06 | --sort-byはname、kindの値のみ受け付ける | E-01 行120-127 | ○ |
| C-07 | --cachedフラグでキャッシュ使用を制御する | E-01 行113, 174-177 | ○ |
| C-08 | デフォルト出力列はNAME, SHORTNAMES, APIVERSION, NAMESPACED, KIND | E-01 行255 | ○ |
| C-09 | wide出力時にVERBS, CATEGORIESが追加される | E-01 行256-257 | ○ |
| C-10 | 安定ソート（sort.Stable）を使用 | E-01 行245 | ○ |
| C-11 | Verbsが空のリソースはフィルタアウトされる | E-01 行204-205 | ○ |
| C-12 | 引数は受け付けない | E-01 行131-133 | ○ |
| C-13 | 部分エラー許容（ServerPreferredResourcesのエラーをerrsに追加して続行） | E-01 行181-183 | ○ |
| C-14 | 関連機能109-API Resources表示が主機能 | E-03 画面No42 | ○ |
| C-15 | Other Commandsカテゴリに属する | E-02 画面No42 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用コマンドで実装も明確

## 6) レビュアーチェックリスト（最小）
- [ ] PrintFlagsの実装が同パッケージ内にあるか確認
- [ ] ServerPreferredResourcesの部分エラー時の挙動が正確に記述されているか確認
